/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.DoggyItems;
import doggytalents.api.anim.DogAnimation;
import doggytalents.client.screen.StringEntrySelectScreen;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.item.DogAnimDebugItem;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogAnimDebugData;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;

public class DogAnimDebugScreen
extends StringEntrySelectScreen {
    private Font font;
    private List<DogAnimation> animList;
    private DogAnimDebugItem.ItemMode selectMode = DogAnimDebugItem.ItemMode.ANIM;
    private DogAnimation selectAnim = DogAnimation.NONE;

    public DogAnimDebugScreen(Player player) {
        super((Component)Component.m_237119_());
        this.font = Minecraft.m_91087_().f_91062_;
        this.animList = Arrays.stream(DogAnimation.values()).collect(Collectors.toList());
        this.getSelectModeFromPlayer(player);
        this.getSelectAnimFromPlayer(player);
    }

    private void getSelectModeFromPlayer(Player player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() != DoggyItems.DOG_ANIM_DEBUG.get()) {
            return;
        }
        this.selectMode = DogAnimDebugItem.getItemMode(stack);
    }

    private void getSelectAnimFromPlayer(Player player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() != DoggyItems.DOG_ANIM_DEBUG.get()) {
            return;
        }
        this.selectAnim = DogAnimDebugItem.getSelectedAnimation(stack);
    }

    public static void open(Player player) {
        Minecraft mc = Minecraft.m_91087_();
        mc.m_91152_((Screen)new DogAnimDebugScreen(player));
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.initEntries();
        this.addModeButton();
    }

    @Override
    protected void onEntrySelected(int id) {
        DogAnimation anim_selected = this.animList.get(id);
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogAnimDebugData.UpdateItemSettingsData(anim_selected, this.selectMode));
        this.f_96541_.m_91152_(null);
    }

    private void addModeButton() {
        int mx = this.f_96543_ / 2;
        int my = this.f_96544_ / 2;
        int modeButton_width = 70;
        int modeButton_height = 20;
        boolean help_render_below_view = this.shouldRenderHelpBelow();
        FlatButton modeButton = new FlatButton(mx - this.getSelectAreaSize() / 2 - 70 - 2, my - this.getSelectAreaSize() / 2, 70, 20, this.getModeTitle(this.selectMode), b -> {
            DogAnimDebugItem.ItemMode new_mode;
            this.selectMode = new_mode = this.selectMode.cycleMode();
            b.m_93666_(this.getModeTitle(this.selectMode));
            this.sendItemChangeRequest();
            if (!help_render_below_view) {
                b.m_257544_(Tooltip.m_257550_((Component)this.getModeHelp(this.selectMode)));
            }
        });
        if (!help_render_below_view) {
            modeButton.m_257544_(Tooltip.m_257550_((Component)this.getModeHelp(this.selectMode)));
        }
        this.m_142416_((GuiEventListener)modeButton);
    }

    private void sendItemChangeRequest() {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogAnimDebugData.UpdateItemSettingsData(this.selectAnim, this.selectMode));
    }

    private Component getModeTitle(DogAnimDebugItem.ItemMode mode) {
        return Component.m_237115_((String)("item.doggytalents.dog_anim_debug_stick.mode." + mode.getId()));
    }

    private Component getModeHelp(DogAnimDebugItem.ItemMode mode) {
        return Component.m_237115_((String)("item.doggytalents.dog_anim_debug_stick.mode." + mode.getId() + ".help"));
    }

    private void initEntries() {
        this.updateEntries(this.getAnimNameList());
    }

    private List<String> getAnimNameList() {
        return this.animList.stream().map(x -> x.toString()).collect(Collectors.toList());
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.renderHelp(graphics, this.selectMode);
    }

    private boolean shouldRenderHelpBelow() {
        return this.f_96544_ > 353;
    }

    private void renderHelp(GuiGraphics graphics, DogAnimDebugItem.ItemMode mode) {
        if (!this.shouldRenderHelpBelow()) {
            return;
        }
        int mX = this.f_96543_ / 2;
        Component desc = this.getModeHelp(mode);
        int max_width = Math.min(360, this.f_96543_ - 10);
        List desc_lines = this.font.m_92923_((FormattedText)desc, max_width);
        int tX = mX - this.font.m_92852_((FormattedText)this.f_96539_) / 2;
        int tY = this.f_96544_ / 2 + this.getSelectAreaSize() / 2 + 20;
        for (FormattedCharSequence line : desc_lines) {
            tX = mX - this.font.m_92724_(line) / 2;
            graphics.m_280648_(this.font, line, tX, tY, -1);
            Objects.requireNonNull(this.font);
            tY += 9 + 2;
        }
    }

    @Override
    protected boolean matchIgnoreCaseSearch() {
        return true;
    }
}

